<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!function_exists('to_charset'))
{
	/**
	 * Converts a string from one character encoding to another.
	 * If the target encoding is not specified then it will be resolved from the current
	 * language settings.
	 *
	 * @param	string	The string to convert
	 * @param	string	The source encoding
	 * @return	string	The target encoding
	 */
	function to_charset($in, $in_encoding, $target_encoding = false)
	{
		if (!$target_encoding)
		{
			global $stylevar;
			if (!($target_encoding = $stylevar['charset']))
			{
				global $vbulletin;
				if (!($target_encoding = $vbulletin->userinfo['lang_charset']))
				{
					return $in;
				}
			}
		}

		// Try iconv
		if (function_exists('iconv') AND $out = @iconv($in_encoding, $target_encoding, $in))
		{
			return $out;
		}

		// Try mbstring
		if (function_exists('mb_convert_encoding') AND $out = @mb_convert_encoding($in, $target_encoding, $in_encoding))
		{
			return $out;
		}

		return $in;
	}
}

/**
 * Converts a string from one character encoding to another.
 * If the source encoding is not specified then it will be resolved from the current
 * language settings.
 *
 * @param	string	The string to convert
 * @param	string	The target encoding
 * @return	string	The source encoding
 */
function from_charset($in, $target_encoding, $in_encoding = false)
{
	global $vbulletin;
	if (!$in_encoding)
	{
		if (intval($vbulletin->versionnumber) == 3)
		{
			global $stylevar;
			$in_encoding = $stylevar['charset'];
		}
		else
		{
			$in_encoding = vB_Template_Runtime::fetchStyleVar('charset');
		}

		if (!$in_encoding)
		{
			if (!($in_encoding = $vbulletin->userinfo['lang_charset']))
			{
				return $in;
			}
		}
	}

	// Try iconv
	if (function_exists('iconv') AND $out = @iconv($in_encoding, $target_encoding, $in))
	{
		return $out;
	}

	// Try mbstring
	if (function_exists('mb_convert_encoding') AND $out = @mb_convert_encoding($in, $target_encoding, $in_encoding))
	{
		return $out;
	}

	return $in;
}

function reverseEntities($matches)
{
	return mb_convert_encoding($matches[1], "UTF-8", "HTML-ENTITIES");
}

function reverseEntities2($matches)
{
	return mb_convert_encoding($matches[1], mb_internal_encoding(), "HTML-ENTITIES");
}


// #############################################################################
function construct_ordered_categories()
{
	$categories = array();
	foreach (VBDOWNLOADS::$cache['category'] as $categoryid => $category)
	{
		if ($category['parentid'])
		{
			// A child category
			continue;
		}

		// Construct array of children
		$category['children'] = find_category_children($categoryid);

		// Parent category
		$categories[$categoryid] = $category;
	}

	return $categories;
}

// #############################################################################
function find_category_children($parentid)
{
	$children = array();
	foreach (VBDOWNLOADS::$cache['category'] as $categoryid => $category)
	{
		if ($category['parentid'] == $parentid)
		{
			$category['children'] = find_category_children($categoryid);
			$children[] = $category;
		}
	}

	return $children;
}

// #############################################################################
function construct_category_select_options(&$options, $categories, $depth = 0, $doDepth = true, $doChildren = true)
{
	foreach ($categories as $category)
	{
		// Table data
		$options[$category['categoryid']] = ($doDepth ? construct_category_depth_mark($depth, '--') . ' ' : '') . $category['title'];

		if (count($category['children']) AND $doChildren)
		{
			// Print children
			construct_category_select_options($options, $category['children'], $depth + 1, $doDepth);
		}
	}
}

// #############################################################################
function print_category_rows($categories, $depth = 1, $lookup = array())
{
	global $vbphrase;

	foreach ($categories as $category)
	{
		// Table data
		$cell = array();
		$cell[] = construct_category_depth_mark($depth, '--') . ' ' . $category['title'];
		$cell[] = nl2br($category['description']);
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$category[categoryid]]\" value=\"$category[displayorder]\" tabindex=\"1\" size=\"3\" title=\"" . $vbphrase['edit_display_order'] . "\" />";
		/*DBTECH_PRO_START*/
		$cell[] = ($lookup[$category['ownerid']] ? $lookup[$category['ownerid']] : '<span class="col-i"><strong>' . $vbphrase['dbtech_downloads_no_owner'] . '</strong></span>');
		$cell[] = ($category['moderated'] ? '<span class="col-i"><strong>' . $vbphrase['yes'] . '</strong></span>' : $vbphrase['no']);
		/*DBTECH_PRO_END*/
		$cell[] = construct_link_code($vbphrase['edit'], 'vbdownloads.php?' . $vbulletin->session->vars['sessionurl'] . 'do=category&amp;action=modify&amp;categoryid=' . $category['categoryid']);
		$cell[] = construct_link_code($vbphrase['delete'], 'vbdownloads.php?' . $vbulletin->session->vars['sessionurl'] . 'do=category&amp;action=delete&amp;categoryid=' . $category['categoryid']);
		
		// Print the data
		print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);

		if (count($category['children']))
		{
			// Print children
			print_category_rows($category['children'], $depth + 1);
		}
	}
}

// #############################################################################
function print_category_rows_frontend($categories, $depth = 1, $lookup = array())
{
	global $vbulletin, $vbphrase, $show;

	$categorybits = '';
	foreach ($categories as $category)
	{
		$category['owner'] = ($lookup[$category['ownerid']] ? $lookup[$category['ownerid']] : '<b>' . $vbphrase['dbtech_downloads_no_owner'] . '</b>');
		$category['title'] = construct_category_depth_mark($depth, '--') . ' ' . $category['title'];
		$show['caneditcategory'] = (($category['ownerid'] == $vbulletin->userinfo['userid'] AND $vbulletin->userinfo['userid']) OR VBDOWNLOADS::$permissions['ismanager']);

		$templater = vB_Template::create('dbtech_downloads_category_list_bit');
			$templater->register('category', 	$category);
		$categorybits .= $templater->render();

		if (count($category['children']))
		{
			// Print children
			$categorybits .= print_category_rows_frontend($category['children'], $depth + 1);
		}
	}

	return $categorybits;
}

// #############################################################################
/**
* Prints a row containing a list of <input type="checkbox" />
*
* @param	string	Title for row
* @param	string	Name for checkbox
* @param	array	Values to use
* @param	boolean	Whether or not to check the box
* @param	boolean	Whether or not to htmlspecialchars the title
*/
function print_checkbox_array_row($title, $name, $array, $selected = '', $htmlise = false)
{
	global $vbulletin;

	if (function_exists('fetch_uniqueid_counter'))
	{
		$uniqueid = fetch_uniqueid_counter();
	}

	if (!is_array($array))
	{
		$array = array();
		$selected = array();
	}

	$check = "<div id=\"ctrl_$name\">\n";
	$check .= construct_checkbox_options($name, $array, $selected, $htmlise);
	$check .= "</div>\n";

	print_label_row($title, $check, '', 'top', $name);
}

// #############################################################################
/**
* Creates <input type="checkbox" /> from an array
*
* @param	string	Name for checkbox
* @param	array	Values to use
* @param	boolean	Whether or not to check the box
* @param	string	Value for checkbox
* @param	string	Text label for checkbox
* @param	string	Optional Javascript code to run when checkbox is clicked - example: ' onclick="do_something()"'
*/
function construct_checkbox_options($name, $array, $selected = '', $htmlise = false)
{
	global $vbulletin;

	$box = '';

	foreach ($array as $value => $title)
	{
		if (function_exists('fetch_uniqueid_counter'))
		{
			$uniqueid = fetch_uniqueid_counter();
		}
		$checked = in_array($value, (array)$selected);
		$box .= "<div id=\"ctrl_$name_$value\" class=\"\"><label for=\"{$name}_$uniqueid\" class=\"smallfont\"><input class=\"primary checkbox frontend-padding\" type=\"checkbox\" name=\"{$name}\" id=\"{$name}_$uniqueid\" value=\"$value\" tabindex=\"1\"" . iif($onclick, " onclick=\"$onclick\"") . iif($vbulletin->debug, " title=\"name=&quot;{$name}&quot;\"") . iif($checked, ' checked="checked"') . " />" . iif($htmlise, htmlspecialchars_uni($title), $title) . "</label></div>\n";
	}

	return $box;
}

// #############################################################################
/**
* Returns a 'depth mark' for use in prefixing items that need to show depth in a hierarchy
*
* @param	integer	Depth of item (0 = no depth, 3 = third level depth)
* @param	string	Character or string to repeat $depth times to build the depth mark
* @param	string	Existing depth mark to append to
*
* @return	string
*/
function construct_category_depth_mark($depth, $depthchar, $depthmark = '')
{
	for ($i = 0; $i < $depth; $i++)
	{
		$depthmark .= $depthchar;
	}
	return $depthmark;
}

// #############################################################################
/**
* Returns a list of <option> tags representing the list of forums
*
* @param	boolean	Whether or not to display the 'Select Forum' option
* @param	string	If specified, name for the optional top element - no name, no display
* @param	string	Text to be used in sprintf() to indicate a 'category' forum, eg: '%s (Category)'. Leave blank for no category indicator
*
* @return	string	List of <option> tags
*/
function construct_category_forum_chooser_options($displayselectforum = false, $topname = null, $category_phrase = null)
{
	global $vbulletin, $vbphrase;

	$selectoptions = array();

	if ($displayselectforum)
	{
		$selectoptions[0] = $vbphrase['dbtech_downloads_select_forum'];
	}

	if ($topname)
	{
		$selectoptions['-1'] = $topname;
		$startdepth = '--';
	}
	else
	{
		$startdepth = '';
	}

	if (!$category_phrase)
	{
		$category_phrase = '%s';
	}

	foreach ($vbulletin->forumcache AS $forumid => $forum)
	{
		if (!($forum['options'] & $vbulletin->bf_misc_forumoptions['cancontainthreads']))
		{
			$forum['title'] = sprintf($category_phrase, $forum['title']);
		}

		$selectoptions["$forumid"] = construct_category_depth_mark($forum['depth'], '--', $startdepth) . ' ' . $forum['title'] . ' ' . iif(!($forum['options'] & $vbulletin->bf_misc_forumoptions['allowposting']), " ($vbphrase[forum_is_closed_for_posting])");
	}

	return $selectoptions;
}